/*
 * Decompiled with CFR 0.152.
 */
package Entity;

import Entity.Animation;
import Entity.Enemy;
import Entity.MapObject;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class Player
extends MapObject {
    private int health;
    private int maxHealth;
    private int arrow;
    private int maxArrow;
    private boolean dead;
    private boolean flinching;
    private long flinchTimer;
    private int score;
    private boolean firing;
    private int arrowCost;
    private int arrowDamage;
    private boolean stab;
    private int stabDamage;
    private int stabRange;
    private ArrayList<BufferedImage[]> sprites;
    private final int[] numFrames = new int[]{1, 3, 1, 1, 2};
    private static final int IDLE = 0;
    private static final int WALKING = 1;
    private static final int JUMPING = 2;
    private static final int FALLING = 3;
    private static final int STABBING = 4;

    public Player(TileMap tm) {
        super(tm);
        this.width = 30;
        this.height = 30;
        this.cwidth = 20;
        this.cheight = 20;
        this.moveSpeed = 0.3;
        this.maxSpeed = 1.6;
        this.stopSpeed = 0.4;
        this.fallSpeed = 0.3;
        this.maxFallSpeed = 4.0;
        this.jumpStart = -4.8;
        this.stopJumpSpeed = 0.3;
        this.facingRight = true;
        this.maxHealth = 5;
        this.health = 5;
        this.maxArrow = 20;
        this.arrow = 20;
        this.score = 0;
        this.arrowCost = 1;
        this.arrowDamage = 5;
        this.stabDamage = 3;
        this.stabRange = 35;
        try {
            BufferedImage spritesheet = ImageIO.read(this.getClass().getResourceAsStream("/Sprites/Knight/Knight.png"));
            this.sprites = new ArrayList();
            int i = 0;
            while (i < 5) {
                BufferedImage[] bi = new BufferedImage[this.numFrames[i]];
                int j = 0;
                while (j < this.numFrames[i]) {
                    bi[j] = spritesheet.getSubimage(j * this.height, i * this.height, this.width, this.height);
                    ++j;
                }
                this.sprites.add(bi);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.animation = new Animation();
        this.currentAction = 0;
        this.animation.setFrames(this.sprites.get(0));
        this.animation.setDelay(400L);
    }

    public int getHealth() {
        return this.health;
    }

    public int getMaxHealth() {
        return this.maxHealth;
    }

    public int getArrow() {
        return this.arrow;
    }

    public int getMaxArrow() {
        return this.maxArrow;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int i) {
        this.score = i;
    }

    public void reset() {
        this.health = 5;
    }

    public void setHealth(int i) {
        this.health = i;
    }

    public void setFiring() {
        this.firing = true;
    }

    public void setStabbing() {
        this.stab = true;
    }

    private void getNextPosition() {
        if (this.left) {
            this.dx -= this.moveSpeed;
            if (this.dx < -this.maxSpeed) {
                this.dx = -this.maxSpeed;
            }
        } else if (this.right) {
            this.dx += this.moveSpeed;
            if (this.dx > this.maxSpeed) {
                this.dx = this.maxSpeed;
            }
        } else if (this.dx > 0.0) {
            this.dx -= this.stopSpeed;
            if (this.dx < 0.0) {
                this.dx = 0.0;
            }
        } else if (this.dx < 0.0) {
            this.dx += this.stopSpeed;
            if (this.dx > 0.0) {
                this.dx = 0.0;
            }
        }
        if (!(this.currentAction != 4 && this.currentAction != 4 || this.jumping || this.falling)) {
            this.dx = 0.0;
        }
        if (this.jumping && !this.falling) {
            this.dy = this.jumpStart;
            this.falling = true;
        }
        if (this.falling) {
            if (this.falling) {
                this.dy += this.fallSpeed;
            }
            if (this.dy > 0.0) {
                this.jumping = false;
            }
            if (this.dy < 0.0 && !this.jumping) {
                this.dy += this.stopJumpSpeed;
            }
            if (this.dy > this.maxFallSpeed) {
                this.dy = this.maxFallSpeed;
            }
        }
    }

    public void update() {
        long elapsed;
        this.getNextPosition();
        this.checkTileMapCollision();
        this.setPosition(this.xtemp, this.ytemp);
        if (this.currentAction == 4 && this.animation.hasPlayedOnce()) {
            this.stab = false;
        }
        if (this.flinching && (elapsed = (System.nanoTime() - this.flinchTimer) / 1000000L) > 1000L) {
            this.flinching = false;
        }
        if (this.stab) {
            if (this.currentAction != 4) {
                this.currentAction = 4;
                this.animation.setFrames(this.sprites.get(4));
                this.animation.setDelay(50L);
                this.width = 30;
            }
        } else if (this.dy > 0.0) {
            if (this.currentAction != 3) {
                this.currentAction = 3;
                this.animation.setFrames(this.sprites.get(3));
                this.animation.setDelay(100L);
                this.width = 30;
            }
        } else if (this.dy < 0.0) {
            if (this.currentAction != 2) {
                this.currentAction = 2;
                this.animation.setFrames(this.sprites.get(2));
                this.animation.setDelay(0L);
                this.width = 30;
            }
        } else if (this.left || this.right) {
            if (this.currentAction != 1) {
                this.currentAction = 1;
                this.animation.setFrames(this.sprites.get(1));
                this.animation.setDelay(40L);
                this.width = 30;
            }
        } else if (this.currentAction != 0) {
            this.currentAction = 0;
            this.animation.setFrames(this.sprites.get(0));
            this.animation.setDelay(400L);
            this.width = 30;
        }
        this.animation.update();
        if (this.currentAction != 4 && this.currentAction != 4) {
            if (this.right) {
                this.facingRight = true;
            }
            if (this.left) {
                this.facingRight = false;
            }
        }
    }

    @Override
    public void draw(Graphics2D graphics) {
        long elapsed;
        this.setMapPosition();
        if (this.flinching && (elapsed = (System.nanoTime() - this.flinchTimer) / 1000000L) / 100L % 2L == 0L) {
            return;
        }
        super.draw(graphics);
    }

    public void checkAttack(ArrayList<Enemy> enemies) {
        int i = 0;
        while (i < enemies.size()) {
            Enemy e = enemies.get(i);
            if (this.stab) {
                if (this.facingRight) {
                    if ((double)e.getx() > this.x && (double)e.getx() < this.x + (double)this.stabRange && (double)e.gety() > this.y - (double)(this.height / 2) && (double)e.gety() < this.y + (double)(this.height / 2)) {
                        e.hit(this.stabDamage);
                    }
                } else if ((double)e.getx() < this.x && (double)e.getx() > this.x - (double)this.stabRange && (double)e.gety() > this.y - (double)(this.height / 2) && (double)e.gety() < this.y + (double)(this.height / 2)) {
                    e.hit(this.stabDamage);
                }
            }
            if (this.intersects(e)) {
                this.hit(e.getDamage());
            }
            ++i;
        }
    }

    public void hit(int damage) {
        if (this.flinching) {
            return;
        }
        this.health -= damage;
        if (this.health < 0) {
            this.health = 0;
        }
        if (this.health == 0) {
            this.dead = true;
        }
        this.flinching = true;
        this.flinchTimer = System.nanoTime();
    }
}

